//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.1
import QtGraphicalEffects 1.0

import wesual.data.Core 1.0
import wesual.Controls 1.0

Rectangle {
    id : menuButton

    property var items
    property int currentIndex  : 0

    readonly property bool open : popup.popupVisible

    function openPopup()  {
        popup.activeIndex = -1;
        popup.show();
        popup.popupItem.focus = true;
    }

    activeFocusOnTab : true

    onOpenChanged : {
        if (!open && !popup.closedOnTab)
            menuButton.forceActiveFocus();
        else
            popup.closedOnTab = false;
    }

    // Key handling
    Keys.onSpacePressed : {
        if (!popup.popupVisible) {
            menuButton.openPopup();
        }
    }
    Keys.onDownPressed : {
        if (!open) {
            openPopup();
        }
    }

    implicitHeight : 26
    implicitWidth  : text.implicitWidth + indicator.width + 13
    z : popup.popupVisible ? 10000 : 0

    color : UI.color(UI.PrimaryBase)

    states : [
        State {
            name : "selected"
            when : ma.pressed || popup.popupVisible

            PropertyChanges {
                target : menuButton
                color : UI.color(UI.PrimaryPress)
            }
        },
        State {
            name : "hovered"
            when : ma.containsMouse || activeFocus

            PropertyChanges {
                target : menuButton
                color  : UI.color(UI.PrimaryHover)
            }
        }
    ]

    Text {
        id : text
        font {
            family : UI.fontFamily(UI.PrimaryFont)
            weight : UI.fontWeight(UI.PrimaryFont)
            pixelSize : 14
        }
        color : menuButton.state === "selected" ?
                UI.color(UI.SelectedTextColor) :
                UI.color(UI.PrimaryTextColor)

        anchors {
            verticalCenter : parent.verticalCenter
            left : parent.left
            leftMargin : 5
        }
        text : items[currentIndex]
    }

    Rectangle {
        id : indicator

        anchors.right : parent.right
        height : parent.height
        width  : 15
        color : parent.color

        ColorizedImage {
            id : image
            anchors.verticalCenter : parent.verticalCenter
            source : "qrc:/controls/icons/dropdown-indicator.png"
            width  : 10
            height :  5
            anchors {
                right : parent.right
                rightMargin : 5
                verticalCenter : parent.verticalCenter
            }
            color : ma.pressed || popup.popupVisible ?
                    UI.color(UI.PrimaryBase) : UI.color(UI.DropdownIndicatorIcon)
        }
    }

    MouseArea {
        id : ma
        anchors.fill : parent
        hoverEnabled : true
        onClicked : openPopup()
        cursorShape : Qt.PointingHandCursor
    }

    DropdownMenuPopup {
        id : popup

        items : menuButton.items
        anchors.centerIn : parent
        onAccepted : {
            if (result !== -1)
                menuButton.currentIndex = result;
            popup.hide();
        }
    }
}
